 ; Ŀ
 ;   Grl - colour the layer of a selected entity gray.                     
 ;   Copyright 1994, 2002, 2003, 2008, 2010 by Rocket Software Ltd.        
 ;   Intended for use with xref layers.                                    
 ; 

 ; Ŀ
 ;   Subroutine Grla - change something about the layer of a selected      
 ;   entity or subentity.                                                  
 ;   If an entity is on 0 Grla checks the layer nesting list returned by   
 ;   Nozo to see if the entity is a subentity of something on a non-zero   
 ;   laye, and if so changes the first non-0 one it finds.                 
 ;   Yalf.lsp uses a different method of finding a non-0 layer to freeze.  
 ;   Grla doesn't handle bit-position replacements yet.                    
 ;   Arguments: Asoc, the association number to change.                    
 ;              Vala, the new value.                                       
 ;              Prom, the partial prompt string.                           
 ;   Calls Nozo, returns nothing.                                          
 ; 
 (DEFUN GRLA (asoc vala prom / snapp *error* enampt enam entt layy lnam)
  (setvar "cmdecho" 0)
  (setq snapp (getvar "snapmode"))
  (setvar "snapmode" 0)
  (defun *error* (shk /) (if snapp (setvar "snapmode" snapp)) (princ))
 ; Ŀ
 ;   Get an entity or subentity.                                           
 ; 
  (if (setq enampt (nentsel (strcat "Entity on layer to " prom ": ")))
      (progn
           (setq lalis (nozo enampt))
           (while (= (setq layy (car lalis)) "0")
                  (setq lalis (cdr lalis)))
           (if layy (princ layy))
 ; Ŀ
 ;   If the entity was on a layer other than 0, change the layer.          
 ; 
           (if (null layy)
               (prompt "\nThis routine is not authorized to change layer 0.")
               (progn
                    (setq lnam (tblobjname "layer" layy))
                    (setq entt (entget lnam))
                    (entmod (subst (cons asoc vala)
                                   (assoc asoc entt) entt)))))
 ; Ŀ
 ;   Else tell the user he missed, because it may not be apparent when     
 ;   making subtle changes that nothing happened.                          
 ; 
      (prompt "\nNothing Selected."))
 ; Ŀ
 ;   Clean up and end.                                                     
 ; 
  (setvar "snapmode" snapp)
 (princ))
 ; Ŀ
 ;   Subroutine Grl end.                                                   
 ; 

 ; Ŀ
 ;   Subroutine Nozo - get the layer nesting on an entity.                 
 ;   Takes one argument, the list returned by nentsel.                     
 ;   Returns a list of layers, from the bottom up.                         
 ; 
 (DEFUN NOZO (aa / enam clay gnulis)
 ; Ŀ
 ;   Get the layer of the first entity - this is the best one to modify.   
 ; 
  (setq gnulis (list (cdr (assoc 8 (entget (setq enam (car aa)))))))
  (setq aa (car (reverse aa)))
  (if (= (type (car aa)) 'ENAME)
      (while (setq enam (car aa))
             (setq aa (cdr aa))
             (setq clay (cdr (assoc 8 (entget enam))))
             (setq gnulis (cons clay gnulis))))
 (reverse gnulis))
 ; Ŀ
 ;   Nozo end.                                                             
 ; 

 ; Ŀ
 ;   Grl - colour the layer of a selected entity gray (8).                 
 ; 
 (DEFUN C:GRL () (grla 62 8 "colour grey") (princ))

 ; Ŀ
 ;   Other routines are named by the colour they use.                      
 ; 
 (DEFUN C:RED () (grla 62 1 "Red") (princ))
 (DEFUN C:YEL () (grla 62 2 "Yellow") (princ))
 (DEFUN C:GRN () (grla 62 3 "Green") (princ))
 (DEFUN C:CYAN () (grla 62 4 "Cyan") (princ))
 (DEFUN C:BLU () (grla 62 5 "Blue") (princ))
 (DEFUN C:MAG () (grla 62 6 "Mag") (princ))
 (DEFUN C:WHT () (grla 62 7 "White") (princ))
 ; Caution: these aren't exactly right for Enerplus.
 (DEFUN C:249 () (grla 62 249 "10% screen") (princ))  ; 10% screening @ 0.0w
 (DEFUN C:250 () (grla 62 250 "20% screen") (princ))  ; 20% screening
 (DEFUN C:251 () (grla 62 251 "90% screen") (princ))  ; 90% screening
 (DEFUN C:252 () (grla 62 252 "75% screen") (princ))  ; 75% screening
 (DEFUN C:253 () (grla 62 253 "50% screen") (princ))  ; 50% screening
 (DEFUN C:254 () (grla 62 254 "25% screen") (princ))  ; 25% screening

 ; Ŀ
 ;   Nop - make the layer of a selected entity not plot.                   
 ; 
 (DEFUN C:NOP () (grla 290 0 "not plot") (princ))

 ; Ŀ
 ;   Pon - make the layer of a selected entity plot.                       
 ; 
 (DEFUN C:PON () (grla 290 1 "plot") (princ))

 (princ)
